// DShowTut1.cpp : Defines the entry point for the application.
//

#include <windows.h>
#include <objbase.h>
#include <streams.h>

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	HRESULT			hr;
	IGraphBuilder*	pGraphBuilder;
	IMediaControl*	pMediaControl;
	WCHAR			MediaFile[MAX_PATH];

	CoInitialize(NULL);
	
	hr = CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_ALL, IID_IGraphBuilder,
							(void**)&pGraphBuilder);
	if (FAILED(hr))
		return -1;

	MultiByteToWideChar(CP_ACP, 0, lpCmdLine, -1, MediaFile, MAX_PATH);
	hr = pGraphBuilder->RenderFile(MediaFile, NULL);
	if (FAILED(hr))
		return -2;

	hr = pGraphBuilder->QueryInterface(IID_IMediaControl, (void**)&pMediaControl);
	if (FAILED(hr))
		return -3;

	hr = pMediaControl->Run();
	if (FAILED(hr))
		return -4;

	Sleep(10000);

	pMediaControl->Stop();
	pMediaControl->Release();
	pGraphBuilder->Release();

	CoUninitialize();

	return 0;
}



